// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.util.OAIUtil;
import org.xml.sax.Attributes;
import java.util.Iterator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;
import org.xml.sax.ContentHandler;
import java.net.URL;
import java.util.ArrayList;

public class ListIdentifiers extends HarvesterVerb
{
    private static final boolean debug = false;
    private boolean resumptionTokenCapture;
    private StringBuffer resumptionToken;
    private boolean headerCapture;
    private StringBuffer header;
    private ArrayList headers;
    
    public ListIdentifiers(final URL baseURL, final String from, final String until, final String set, final String metadataPrefix) throws MalformedURLException, SAXException, IOException {
        this.resumptionTokenCapture = false;
        this.resumptionToken = new StringBuffer();
        this.headerCapture = false;
        this.header = new StringBuffer();
        this.headers = new ArrayList();
        final StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(getParams(from, until, set, metadataPrefix));
        final XMLReader xmlReader = this.getXMLReader();
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + (Object)query);
            e.printStackTrace();
            throw e;
        }
    }
    
    public ListIdentifiers(final URL baseURL, final String resumptionToken) throws MalformedURLException, SAXException, IOException {
        this.resumptionTokenCapture = false;
        this.resumptionToken = new StringBuffer();
        this.headerCapture = false;
        this.header = new StringBuffer();
        this.headers = new ArrayList();
        final StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(getParams(resumptionToken));
        final XMLReader xmlReader = this.getXMLReader();
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + (Object)query);
            e.printStackTrace();
            throw e;
        }
    }
    
    private static String getParams(final String from, final String until, final String set, final String metadataPrefix) throws IOException {
        try {
            final StringBuffer query = new StringBuffer();
            query.append("verb=ListIdentifiers");
            if (until != null && until.length() != 0) {
                query.append("&until=");
                query.append(URLEncoder.encode(until, "UTF-8"));
            }
            if (from != null && from.length() != 0) {
                query.append("&from=");
                query.append(URLEncoder.encode(from, "UTF-8"));
            }
            if (set != null && set.length() != 0) {
                query.append("&set=");
                query.append(URLEncoder.encode(set, "UTF-8"));
            }
            query.append("&metadataPrefix=");
            query.append(URLEncoder.encode(metadataPrefix, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
    
    private static String getParams(final String resumptionToken) throws IOException {
        try {
            final StringBuffer query = new StringBuffer();
            query.append("verb=ListIdentifiers");
            query.append("&resumptionToken=");
            query.append(URLEncoder.encode(resumptionToken, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
    
    public Iterator iterator() {
        return this.headers.iterator();
    }
    
    public String getResumptionToken() {
        if (this.resumptionToken.length() == 0) {
            return null;
        }
        return this.resumptionToken.toString();
    }
    
    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("resumptionToken: ");
        sb.append(this.resumptionToken);
        sb.append("\n");
        sb.append(super.toString());
        return sb.toString();
    }
    
    public void startElement(final String namespaceURI, final String localName, final String qName, final Attributes attrs) {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (!this.headerCapture && fullName.equals(HarvesterVerb.OAI20_HEADER)) {
            this.header.setLength(0);
            this.headerCapture = true;
        }
        if (this.headerCapture) {
            this.header.append("<");
            this.header.append(qName);
            for (int length = attrs.getLength(), i = 0; i < length; ++i) {
                this.header.append(" ");
                final String aEName = attrs.getQName(i);
                this.header.append(aEName);
                this.header.append("=\"");
                this.header.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.header.append("\"");
            }
            this.header.append(">");
        }
        else if (fullName.equals(HarvesterVerb.OAI20_RESUMPTION_TOKEN)) {
            this.resumptionTokenCapture = true;
        }
        else {
            super.startElement(namespaceURI, localName, qName, attrs);
        }
    }
    
    public void endElement(final String namespaceURI, final String localName, final String qName) throws SAXException {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (this.headerCapture) {
            this.header.append("</");
            this.header.append(qName);
            this.header.append(">");
        }
        else if (!this.resumptionTokenCapture) {
            super.endElement(namespaceURI, localName, qName);
        }
        if (fullName.equals(HarvesterVerb.OAI20_HEADER)) {
            try {
                this.headers.add(new Header(this.header.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SAXException(e.getMessage());
            }
            this.headerCapture = false;
        }
        else if (fullName.equals(HarvesterVerb.OAI20_RESUMPTION_TOKEN)) {
            this.resumptionTokenCapture = false;
        }
    }
    
    public void characters(final char[] buf, final int offset, final int len) {
        if (this.resumptionTokenCapture) {
            this.resumptionToken.append(new String(buf, offset, len));
        }
        else if (this.headerCapture) {
            this.header.append(OAIUtil.xmlEncode(new String(buf, offset, len)));
        }
        else {
            super.characters(buf, offset, len);
        }
    }
}
